A multicompartment model of a mouse CA1 pyramidal neuron with a detailed myelinated axon was constructed using NEURON v8.0.


"`cell_Primary.hoc`" , "`cell_Alternate.hoc`" are the two versions of the constructed CA1 neuron model. The Models differ only in the density of Kv1 and Kv7 channels (see Methods).

"`geo9068802.hoc`" includes the morphology of the neuron.
 
The `.mod` files are the ion channels included in the model. The `.mod` files must be compiled using nrnivmodl in NEURON. Further instructions on compiling `.mod` files can be found on the NEURON software website. 


To stimulate the neuron, the ICLAMP point process in NEURON was used to inject current at different points in the neuron model. Based on Foutz et al. the photostimulus was modeled in Python and interfaced with the ChR2 model in NEURON. The following files include the codes required for photostimulation:
"`Optical Stimulation.py`" , "`functions.py`" , "`Classes_Alternate`" , "`Classes_Primary`" 

--------------------------------------------------------------------------------------
How to Run the Code:

Primary model:
1. Current stimulation: First run "`cell_Primary.hoc`", then click on File/load session. From the list you can choose any `.ses` file to initiate and run. `.ses` files contain all the required windows to run a specific simulation.

2. Photostimulation: Open "`Optical Stimulation_Primary model.ipynb`". Run the first cell of the jupyter notebook which imports NEURON and all the needed files. The other cells of the jupyter notebook contain information about how to run and generate the photostimulation results. 


Alternate model:
1. Current stimulation: First run "cell_Alternate.hoc", click on File/load session. From the list you can choose .ses files to initiate and run. 

2. Photostimulation: Open "`Optical Stimulation_Alternate model.ipynb`". Run the first cell of the jupyter notebook which imports NEURON and all the needed files. 
The other cells of the jupyter notebook include information about how to run and generate the photostimulation results. 

--------------------------------------------------------------------------------------


